/*-------------------------------------------------------*
*  Name:      DOF filter for ZModeler v1.04              *
*  Purpose:   RACER files import/export                  *
*  Authors:   Oleg M.                                    *
*                                                        *
*  History:   9.September.2001 - project started.        *
*             16.Sep.2001 - rebuild for ZModeler v1.05   *
*             23.Mar.2002 - rebuild for ZModeler v1.06   *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <ZMUserAddons/z3dUserUnits.h>
#include <3dEngine.h>
#include <ZMUserAddons/ZMultipleFilesExport.h>

extern DWORD CALLBACK MultipleExport(CFile &OutFile, tObject* pobj, CDirect3D* d3d);

DWORD CALLBACK Capabilities(long)
{
    return ZMODELER_BUILD_VERSION();
}

DWORD CALLBACK DynamicLoading(long)
{
  return 1;
}

DWORD CALLBACK Supports(long)
{
    return Z3D_PLUGSUPPORTS_IMPORT |
           Z3D_PLUGSUPPORTS_EXPORT;
}

char* CALLBACK GetFilterExtension(long)
{
  return "dof";
}

char* CALLBACK GetFilterMask(long)
{
  return "Racer DOF files |*.dof|";
}

DWORD CALLBACK PluginSafeLoad(tProcParams* params)
{
  float coef = 1.06f;
  params->sysp(
      (sRequestType)Z3D_USERREQUEST_ADDUNIT,
      (tObjectSet*)"meters",
      "RACER meters",
      (long*)&coef,
      NULL);
  return 0;
}


//////////////////////////////////////////////////////////////
//  Shows a failure message.
long ShowFailMessage(CWnd* pwnd, char *errmsg, char *cause, UINT icon)
{
  char str[512];
  strcpy(str, "Error importing/exporting file: ");
  strcat(str, errmsg);
  strcat(str, "\nPossible caused by: ");
  strcat(str, cause);
  pwnd->MessageBox(str,"Filter message:", icon);
  return 0;
}



/**********************************************************************/
// This filter supports multiple files export
/**********************************************************************/
DWORD CALLBACK MultipleExportInfo(DWORD num)
{
  if (num == 0) //DOF
    return  ZMULTIPLE_FILES_EXPORT_NEED_FILES |
            ZMULTIPLE_FILES_EXPORT_NEED_ONEOBJECT |
            ZMULTIPLE_FILES_EXPORT_VISIBLE;
  return 0;
}

char* CALLBACK MultipleExportTitle(DWORD num)
{
  if (num == 0) //DOF
    return "Racer DOF";
  return NULL;
}

char* CALLBACK MultipleExportHint(DWORD num)
{
  return "Select object(s) for exporting.";
}

DWORD CALLBACK MultipleExportRacerDOF(CFile* pFile, tObject* pObject, CDirect3D* pD3D)
{
  return MultipleExport(*(CFile* &)pFile, pObject, pD3D);
}
